<?PHP

/* ====================
Seditio - Website engine
Copyright Neocrome & Seditio Team
http://www.neocrome.net
http://www.seditio.org
[BEGIN_SED]
File=upgrade-seditio1xx-to-seditio173.php
Version=173
Updated=2012-nov-11
Type=Core
Author=Seditio Team
Description=SQL upgrade tool
[END_SED]
==================== */

define('SED_CODE', TRUE);
define('SED_ADMIN', TRUE);

$location = 'Upgrade';
$z = 'upgrade';

error_reporting(E_ALL ^ E_NOTICE);
require('system/functions.php');
require('system/functions.admin.php');
@include('datas/config.php');

if (!empty($cfg['mysqlhost']) || !empty($cfg['mysqldb']))
	{
		require('system/database.'.$cfg['sqldb'].'.php');
		$connection_id = sed_sql_connect($cfg['mysqlhost'], $cfg['mysqluser'], $cfg['mysqlpassword'], $cfg['mysqldb']);
		sed_sql_set_charset($connection_id, 'utf8');
	}

echo "<html>
<head>
<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\" />
<style type=\"text/css\">
<!--
body 		{ background-color:#45444A; margin:32px; font-family:Verdana,Arial,Helvetica; color:#EEEEEE; font-size:12px; }
a 			{ text-decoration: none; color:#AFCCE5; }
a:hover 	{ text-decoration: none; color:#000000; background-color:#AFCCE5; }
h1			{ color: #FFFFFF; font-size:140%; font-weight:bold; margin:1.5em .7em .2em 0em; }
h2			{ color: #FFCC00; font-size:120%; font-weight:bold; margin:1.5em .7em .7em 0em; }
h3			{ color: #FFFFFF; font-size:110%; font-weight:bold; margin:1.5em .7em .7em 0em; }
h4			{ color: #FFFFFF; font-size:100%; font-weight:bold; margin:1.5em .7em .7em 0em; }
h5			{ color: #FFFFFF; font-size:90%; font-weight:bold; margin:1.5em .7em .7em 0em; }
.success	{ color:#73E373; font-weight:bold; }
.mixed		{ color:#6D9FE3; font-weight:bold; }
.failure	{ color:#FF0000; font-weight:bold; }
.fatal		{ color:#FFCC00; font-weight:bold; }
.yes		{ color:#94C280; font-weight:bold; }
.part		{ color:#C0C0FF; font-weight:bold; }
.no			{ color:#BC7474; font-weight:bold; }
ul 			{ list-style-type:square; margin:6px; }
.log {margin:0 auto; height:400px; border: 1px solid #CCCCCC; overflow:auto; padding:10px;}

-->
</style>
</head>
<body>
<h1><a href=\"upgrade-seditio1xx-to-seditio173.php\">Seditio v1xx -> Seditio v1xx : UNIVERSAL UPGRADER</a></h1>
PHP/MySQL Website engines - <a href=\"http://www.seditio.org/\">http://www.seditio.org</a><br />
&nbsp;<br />
";

$step = sed_import('step', 'G', 'TXT');

//Check version
$sql = sed_sql_query("SELECT * FROM ".$cfg['sqldbprefix']."stats WHERE stat_name='version'");
$row = sed_sql_fetchassoc($sql);
$version = (int)$row['stat_value']; // version in DB

$step_by_version = array (100=>'110',102=>'110',110=>'121', 120=>'125', 121=>'125', 125=>'130', 126=>'130', 130=>'150', 150=>'160', 159=>'160', 160=>'171', 161=>'171', 162=>'171', 170=>'171', 171=>'172', 172=>'173', 173=>'end');
$beginstep = array_key_exists($version, $step_by_version) ? $step_by_version[$version] : "end";
$endstep = array_key_exists($cfg['version'], $step_by_version) ? $step_by_version[$cfg['version']] : "end";

/*$step_by_version = array('3' => '110', '4' => '121', '5' => '125', '6' => '130', '7' => '150', '8' => '160', '9' => '171', '10' => '172', '11' => '173');
$beginstep = array_search($version, $step_by_version);
$endstep = array_search($cfg['version'], $step_by_version); // version in functions.php
*/

function sed_pl_uninstall($pl, $all = FALSE)
	{
	global $db_plugins, $db_config, $db_auth, $db_users;

	// New v173 Delete all plugins for upgrade mode
	$where = ($all && $pl=="all") ? "" : " WHERE pl_code='$pl' LIMIT 1";

	$sql0 = sed_sql_query("SELECT * FROM $db_plugins".$where);
	while($row = sed_sql_fetchassoc($sql0))
	{
		$pl = $row['pl_code'];		
		$res .= "<h3>Removing : plugins/".$pl."</h3>"; 
		$sql = sed_sql_query("DELETE FROM $db_plugins WHERE pl_code='$pl'");
		$res .= "Deleting old installation of this plugin... ";
		$res .= "Found:".sed_sql_affectedrows()."<br />";
		$sql = sed_sql_query("DELETE FROM $db_config WHERE config_owner='plug' AND config_cat='$pl'");
		$res .= "Deleting old configuration entries... ";
		$res .= "Found:".sed_sql_affectedrows()."<br />";
		$sql = sed_sql_query("DELETE FROM $db_auth WHERE auth_code='plug' and auth_option='$pl'");
		$res .= "Deleting any old rights about this plugin... ";
		$res .= "Found:".sed_sql_affectedrows()."<br />";
		$sql = sed_sql_query("UPDATE $db_users SET user_auth='' WHERE 1");
		$res .= "Resetting the auth column for all the users... ";     
		$res .= "Found:".sed_sql_affectedrows()."<br />";		
	
		$extplugin_uninstall = "plugins/".$pl."/".$pl.".uninstall.php";
		$res .= "Looking for the optional PHP file : ".$extplugin_uninstall."... ";
		if (file_exists($extplugin_uninstall))
			{
			$res .= "Found, executing...<br />";
			include($extplugin_uninstall);
			}
		else
			{ $res .= "Not found.<br />"; 	}		
	}
	sed_cache_clearall();
	return ($res);
	}

function sed_check_success($extra)
	{
	$res = "<br />";
	$res .= nl2br($extra)." &nbsp; ";
	$res .= " &nbsp; <span class=\"success\">Success</span><br />";
	return ($res);
	}

function sed_check_mixed($extra)
	{
	$res = "<br />";
	$res .= nl2br($extra)." &nbsp; ";
	$res .= " &nbsp; <span class=\"mixed\">Success</span><br />";
	return ($res);
	}

function sed_check_failed($extra)
	{
	$res = "<br />";
	$res .= nl2br($extra)." &nbsp; ";
	$res .= " &nbsp; <span class=\"failure\">Failure !</span><br />";
	return ($res);
	}
	
function sed_buildnxtstep($nxtstep, $steptitle=FALSE)
	{
	global $step_by_version, $endstep; 
//	$title = ($steptitle) ? $steptitle : $nxtstep;
	
	if ($nxtstep == $endstep) { $nxtstep = "end";}
	
	$res = "<div style=\"float:left; width:45%;\"><form action=\"upgrade-seditio1xx-to-seditio173.php?step=".$nxtstep."&".sed_xg()."\" method=\"post\" name=\"nextstep\">";
	$res .= "<input type=\"submit\" value=\"&nbsp; &nbsp; Next  step ! (".$nxtstep.")&nbsp;".$steptitle." &nbsp;\"></form></div>";
	return ($res);
	}

function sed_query_chk($query)
	{
	if ($sql = sed_sql_query($query, FALSE))
		{
		$affected = sed_sql_affectedrows();
		if ($affected==0)
			{  return (sed_check_mixed($query. " (".$affected.")"));
			}
		else
			{  return (sed_check_success($query. " (".$affected.")"));
			}
		}
	else  { return (sed_check_failed($query)); }
	}

// ---------------------------

/* ======== Groups ======== */

if (!$sed_groups )
	{
	$sql = sed_sql_query("SELECT * FROM ".$cfg['sqldbprefix']."groups WHERE grp_disabled=0 ORDER BY grp_level DESC");

	if (sed_sql_numrows($sql)>0)
		{
		while ($row = sed_sql_fetchassoc($sql))
			{
			$sed_groups[$row['grp_id']] = array (
				'id' => $row['grp_id'],
				'alias' => $row['grp_alias'],
				'level' => $row['grp_level'],
 				'disabled' => $row['grp_disabled'],
 				'hidden' => $row['grp_hidden'],
				'state' => $row['grp_state'],
				'title' => sed_cc($row['grp_title']),
				'desc' => sed_cc($row['grp_desc']),
				'icon' => $row['grp_icon'],
				'pfs_maxfile' => $row['grp_pfs_maxfile'],
				'pfs_maxtotal' => $row['grp_pfs_maxtotal'],
				'ownerid' => $row['grp_ownerid']
					);
			}
		}
	else
		{ sed_diefatal('No groups found.'); }

	sed_cache_store('sed_groups',$sed_groups,3600);
	}



// ---------------------------

$step = empty($step) ? 'start' : $step;

// ===========================

switch($step)
	{
// ------------------------------	
case 'start':
// ------------------------------

	$adminmain .=  "<h2>Step ".$step." : Upgrading SQL database from Seditio version ".$version." to version ".$cfg['version']."</h2>";
	$adminmain .=  "<strong>Ready ?</strong><br /><br />";
	$adminmain .=  "This tool will handle the upgrade of the SQL database from Seditio version ".$version." to version ".$cfg['version'].".<br /><br />";
	$adminmain .=  "The process is split into many steps, in case one is failling, roll back to your previous SQL backup, and ask for help in the Seditio.Org forums.<br />Give as much details as possible about the problem, you'll get help faster...<br />&nbsp;<br />NEVER run this upgrade tool more than once ! As soon as it fails, you must go back to a complete SQL backup !<br /><br />";
	$adminmain .=  "Make REALLY sure that you have a backup of your database with phpMyAdmin !<br /><br />";	
	$adminmain .=  "<strong>In the next step will attempt to convert your database to UTF-8. If you have already made the conversion or the conversion with this tool runs with errors, then you can skip this step and go to the next.</strong><br /><br />";

	$next = "<div style=\"width:100%; float:left;\">".sed_buildnxtstep('utf', "Convert Database to UTF-8").sed_buildnxtstep($beginstep, "Skip Convert")."</div>";
	break;
	
 // ------------------------------ 
case 'utf' :
// ------------------------------

	$adminmain .=  "<h2>Step ".$step." : Converting Database to UTF-8</h2>";
	$adminmain .= "<div class=\"log\">";	
	$sqlconvert = sed_sql_query("SELECT CONCAT('ALTER TABLE `', t.`TABLE_NAME`, '` CONVERT TO CHARACTER SET utf8 COLLATE utf8_general_ci;') as sqlcode
	FROM `information_schema`.`TABLES` t WHERE 1 AND t.`TABLE_SCHEMA` = '".$cfg['mysqldb']."' ORDER BY 1");

	while ($rowconvert = sed_sql_fetchassoc($sqlconvert))
	{
	  $adminmain .= sed_query_chk($rowconvert['sqlcode']);
	}  
	$adminmain .= sed_query_chk("ALTER DATABASE `".$cfg['mysqldb']."` DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci");	
	$adminmain .= sed_query_chk("UPDATE sed_config SET config_value='UTF-8' WHERE config_name='charset'");
	$adminmain .= sed_query_chk("TRUNCATE TABLE sed_cache");

	$next = sed_buildnxtstep($beginstep);
	$adminmain .= "</div>";
	break;
	     
// ------------------------------
case '110':
// ------------------------------
	
	$adminmain .= "<h2>Step ".$step." : Upgrade of the SQL database from Seditio v102 to v110</h2>";
	$adminmain .= "<div class=\"log\">";
	$adminmain .= "<br />
	========================================<br />
	-------- Sed 102 to 110 ----------------<br />
	========================================<br />
	<br />";
	/*
	$adminmain .= "Uninstall All plugins<br />";
	$adminmain .= sed_plugin_uninstall('all', TRUE); 
	*/
	
	$sqlqr = "CREATE TABLE ".$cfg['sqldbprefix']."forum_structure (
		fn_id mediumint(8) NOT NULL auto_increment,
		fn_path varchar(16) NOT NULL default '',
		fn_code varchar(16) NOT NULL default '',
		fn_tpl varchar(64) NOT NULL default '',
		fn_title varchar(32) NOT NULL default '',
		fn_desc varchar(255) NOT NULL default '',
		fn_icon varchar(128) NOT NULL default '',
		fn_defstate tinyint(1) NOT NULL default '1',
		PRIMARY KEY  (fn_id)
		) TYPE=MyISAM;";
	$adminmain .= sed_query_chk($sqlqr);
	
	$sqlqr = "ALTER TABLE ".$cfg['sqldbprefix']."smilies ADD COLUMN smilie_order smallint(5) unsigned NOT NULL default '0' AFTER smilie_text;";
	$adminmain .= sed_query_chk($sqlqr);
	
	$sqlqr = "ALTER TABLE ".$cfg['sqldbprefix']."structure ADD COLUMN structure_tpl varchar(64) NOT NULL default '' AFTER structure_path;";
	$adminmain .= sed_query_chk($sqlqr);
	
	$sqlqr = "CREATE TABLE ".$cfg['sqldbprefix']."trash (
		tr_id int(11) NOT NULL auto_increment,
		tr_date int(11) unsigned NOT NULL default '0',
		tr_type varchar(24) NOT NULL default '',
		tr_title varchar(128) NOT NULL default '',
		tr_itemid varchar(24) NOT NULL default '',
		tr_trashedby int(11) NOT NULL default '0',
		tr_datas mediumblob,
		PRIMARY KEY  (tr_id)
		) TYPE=MyISAM;";
	$adminmain .= sed_query_chk($sqlqr);
	
	$sqlqr = "INSERT INTO ".$cfg['sqldbprefix']."config VALUES ('plug', 'recentitems', 03, 'maxpolls', 2, '1', '0,1,2,3,4,5', 'Recent polls displayed');";
	$adminmain .= sed_query_chk($sqlqr);
	
	$sqlqr = "INSERT INTO ".$cfg['sqldbprefix']."config VALUES ('plug', 'cleaner', 01, 'userprune', 2, '2', '0,1,2,3,4,5,6,7', 'Delete the user accounts not activated within * days (0 to disable).');";
	$adminmain .= sed_query_chk($sqlqr);
	
	$sqlqr = "INSERT INTO ".$cfg['sqldbprefix']."config VALUES ('plug', 'cleaner', 02, 'logprune', 2, '15', '0,1,2,3,7,15,30,60', 'Delete the log entries older than * days (0 to disable).');";
	$adminmain .= sed_query_chk($sqlqr);
	
	$sqlqr = "INSERT INTO ".$cfg['sqldbprefix']."config VALUES ('plug', 'cleaner', 03, 'refprune', 2, '30', '0,15,30,60,120,180,365', 'Delete the referer entries older than * days (0 to disable).');";
	$adminmain .= sed_query_chk($sqlqr);
	
	$sqlqr = "INSERT INTO ".$cfg['sqldbprefix']."config VALUES ('plug', 'cleaner', 04, 'pmnotread', 2, '120', '0,15,30,60,120,180,365', 'Delete the private messages older than * days and not read by the recipient (0 to disable).');";
	$adminmain .= sed_query_chk($sqlqr);
	
	$sqlqr = "INSERT INTO ".$cfg['sqldbprefix']."config VALUES ('plug', 'cleaner', 05, 'pmnotarchived', 2, '180', '0,15,30,60,120,180,365', 'Delete the private messages older than * days and not archived (0 to disable).');";
	$adminmain .= sed_query_chk($sqlqr);
	
	$sqlqr = "INSERT INTO ".$cfg['sqldbprefix']."config VALUES ('plug', 'cleaner', 06, 'pmold', 2, '365', '0,15,30,60,120,180,365', 'ALL the private messages older than * days (0 to disable).');";
	$adminmain .= sed_query_chk($sqlqr);
	
	$sqlqr = "INSERT INTO ".$cfg['sqldbprefix']."auth VALUES (157, 1, 'plug', 'ipsearch', 0, 255, 1);";
	$adminmain .= sed_query_chk($sqlqr);
	
	$sqlqr = "INSERT INTO ".$cfg['sqldbprefix']."auth VALUES (158, 2, 'plug', 'ipsearch', 0, 255, 1);";
	$adminmain .= sed_query_chk($sqlqr);
	
	$sqlqr = "INSERT INTO ".$cfg['sqldbprefix']."auth VALUES (159, 3, 'plug', 'ipsearch', 0, 255, 1);";
	$adminmain .= sed_query_chk($sqlqr);
	
	$sqlqr = "INSERT INTO ".$cfg['sqldbprefix']."auth VALUES (160, 4, 'plug', 'ipsearch', 0, 255, 1);";
	$adminmain .= sed_query_chk($sqlqr);
	
	$sqlqr = "INSERT INTO ".$cfg['sqldbprefix']."auth VALUES (161, 5, 'plug', 'ipsearch', 255, 255, 1);";
	$adminmain .= sed_query_chk($sqlqr);
	
	$sqlqr = "INSERT INTO ".$cfg['sqldbprefix']."auth VALUES (162, 6, 'plug', 'ipsearch', 0, 255, 1);";
	$adminmain .= sed_query_chk($sqlqr);
	
	$sqlqr = "INSERT INTO ".$cfg['sqldbprefix']."plugins VALUES (20, 'tools', 'ipsearch', 'admin', 'IP search', 'ipsearch.admin', 10, 1);";
	$adminmain .= sed_query_chk($sqlqr);
	
	$sqlqr = "UPDATE ".$cfg['sqldbprefix']."stats SET stat_value='110' WHERE stat_name='version'";
	$adminmain .= sed_query_chk($sqlqr);
	

	$adminmain .= "-----------------------<br />";

	$next = sed_buildnxtstep('121');
	$adminmain .= "</div>";
	break;
	

// ------------------------------
case '121':
// ------------------------------
	
	$adminmain .=  "<h2>Step ".$step." : Upgrade of the SQL database from Seditio v110 to v121</h2>";
	$adminmain .= "<div class=\"log\">";
	$adminmain .= "<br />
	========================================<br />
	-------- Sed 110 to 121 ----------------<br />
	========================================<br />
	<br />";
	/*
	$adminmain .= "Uninstall All plugins<br />";
	$adminmain .= sed_plugin_uninstall('all', TRUE); 
	*/
	$sqlqr = "UPDATE ".$cfg['sqldbprefix']."pages SET page_expire = '1886531040'";
	$adminmain .= sed_query_chk($sqlqr);

	$sqlqr = "ALTER TABLE ".$cfg['sqldbprefix']."forum_topics ADD COLUMN ft_tag varchar(16) NOT NULL default '' AFTER ft_sticky;";
	$adminmain .= sed_query_chk($sqlqr);

	$sqlqr = "ALTER TABLE ".$cfg['sqldbprefix']."online ADD COLUMN online_subloc varchar(255) NOT NULL default ''  AFTER online_location;";
	$adminmain .= sed_query_chk($sqlqr);

	$sqlqr = "ALTER TABLE ".$cfg['sqldbprefix']."users ADD COLUMN user_newpm tinyint(1) unsigned NOT NULL default '0' AFTER user_pmnotify;";
	$adminmain .= sed_query_chk($sqlqr);

	$sqlqr = "INSERT INTO ".$cfg['sqldbprefix']."config (`config_owner`, `config_cat`, `config_order`, `config_name`, `config_type`, `config_value`, `config_default`, `config_text`) VALUES ('core', 'pfs', '10', 'th_dimpriority', 2, 'Width', 'Width,Height', '')";
	$adminmain .= sed_query_chk($sqlqr);

	$sqlqr = "INSERT INTO ".$cfg['sqldbprefix']."config (`config_owner`, `config_cat`, `config_order`, `config_name`, `config_type`, `config_value`, `config_default`, `config_text`) VALUES ('core', 'parser', '10', 'parser_vid', 3, 1, '', '')";
	$adminmain .= sed_query_chk($sqlqr);

	$sqlqr = "UPDATE ".$cfg['sqldbprefix']."config SET config_cat='parser' WHERE config_name='parsebbcodeusertext'";
	$adminmain .= sed_query_chk($sqlqr);

	$sqlqr = "UPDATE ".$cfg['sqldbprefix']."config SET config_cat='parser' WHERE config_name='parsebbcodecom'";
	$adminmain .= sed_query_chk($sqlqr);

	$sqlqr = "UPDATE ".$cfg['sqldbprefix']."config SET config_cat='parser' WHERE config_name='parsebbcodeforums'";
	$adminmain .= sed_query_chk($sqlqr);

	$sqlqr = "UPDATE ".$cfg['sqldbprefix']."config SET config_cat='parser' WHERE config_name='parsebbcodepages'";
	$adminmain .= sed_query_chk($sqlqr);

	$sqlqr = "UPDATE ".$cfg['sqldbprefix']."config SET config_cat='parser', config_order='30' WHERE config_name='parsesmiliesusertext'";
	$adminmain .= sed_query_chk($sqlqr);

	$sqlqr = "UPDATE ".$cfg['sqldbprefix']."config SET config_cat='parser', config_order='30' WHERE config_name='parsesmiliescom'";
	$adminmain .= sed_query_chk($sqlqr);

	$sqlqr = "UPDATE ".$cfg['sqldbprefix']."config SET config_cat='parser', config_order='30' WHERE config_name='parsesmiliesforums'";
	$adminmain .= sed_query_chk($sqlqr);

	$sqlqr = "UPDATE ".$cfg['sqldbprefix']."config SET config_cat='parser', config_order='30' WHERE config_name='parsesmiliespages'";	
	$adminmain .= sed_query_chk($sqlqr);
	
	$sqlqr = "UPDATE ".$cfg['sqldbprefix']."stats SET stat_value='121' WHERE stat_name='version'";
	$adminmain .= sed_query_chk($sqlqr);

	$adminmain .= "-----------------------<br />";

	$sql0 = sed_sql_query("SELECT ct_id FROM ".$cfg['sqldbprefix']."core WHERE ct_id=13");
	if (sed_sql_numrows($sql0)>0)
	{ $adminmain .= "Step skipped, entry is already in the database"; }
	else
	{ 
	  $sqlqr = "INSERT INTO ".$cfg['sqldbprefix']."core VALUES (13, 'trash', 'Trash can', '110', 1, 1);";   
	  $adminmain .= sed_query_chk($sqlqr);     
	}
	$next = sed_buildnxtstep('125');
	$adminmain .= "</div>";
	break;
	
// ------------------------------
case '125':
// ------------------------------

	$adminmain .=  "<h2>Step ".$step." : Upgrade of the SQL database from Seditio v121 to v125</h2>";
	$adminmain .= "<div class=\"log\">";
	$adminmain .= "<br /> 
	========================================<br />
	-------- Sed 121 to 125 ----------------<br />
	========================================<br />
	<br />";
	/*
	$adminmain .= "Uninstall All plugins<br />";
	$adminmain .= sed_plugin_uninstall('all', TRUE); 
	*/
	$adminmain .= "-----------------------<br />";

	$adminmain .= "Upgrading the forums<br />";
	$adminmain .= "Adding a new colum ft_desc<br />";
	$sqlqr = "ALTER TABLE ".$cfg['sqldbprefix']."forum_topics ADD COLUMN ft_desc varchar(64) NOT NULL default '' AFTER ft_title;";

	$adminmain .= sed_query_chk($sqlqr);
	$adminmain .= "-----------------------<br />";

	$sqlqr = "INSERT INTO ".$cfg['sqldbprefix']."config (`config_owner`, `config_cat`, `config_order`, `config_name`, `config_type`, `config_value`, `config_default`, `config_text`) VALUES ('core', 'main', '05', 'clustermode', 3, 0, '', '')";

	$adminmain .= sed_query_chk($sqlqr);
	$adminmain .= "-----------------------<br />";

	$adminmain .= "Pages and lists<br />";
	$sqlqr = "ALTER TABLE ".$cfg['sqldbprefix']."pages ADD COLUMN page_comcount mediumint(8) unsigned default '0' AFTER page_rating;";

	$adminmain .= sed_query_chk($sqlqr);
	$adminmain .= "-----------------------<br />";

	$sql = sed_sql_query("SELECT DISTINCT com_code, COUNT(*) FROM ".$cfg['sqldbprefix']."com WHERE com_code LIKE 'p%' GROUP BY com_code ASC");

	while ($row = sed_sql_fetchassoc($sql))
	{
	$row['page_id'] = substr($row['com_code'], 1, 10);
	$adminmain .= sed_query_chk("UPDATE ".$cfg['sqldbprefix']."pages SET page_comcount=".$row['COUNT(*)']." WHERE page_id=".$row['page_id']);
	}

	$sqlqr = "ALTER TABLE ".$cfg['sqldbprefix']."pages ADD COLUMN page_text2 text AFTER page_text;";

	$adminmain .= sed_query_chk($sqlqr);
	$adminmain .= "-----------------------<br />";

	$adminmain .= "Create sed_parser table<br />";
	$adminmain .= sed_query_chk("CREATE TABLE ".$cfg['sqldbprefix']."parser (
	parser_id int(11) unsigned NOT NULL auto_increment,
	parser_title varchar(64) collate utf8_unicode_ci NOT NULL default '',
	parser_type tinyint(1) default '0',
	parser_mode tinyint(1) default '0',
	parser_order int(11) NOT NULL default '0',
	parser_bb1 mediumtext collate utf8_unicode_ci,
	parser_bb2 mediumtext collate utf8_unicode_ci,
	parser_code1 mediumtext collate utf8_unicode_ci,
	parser_code2 mediumtext collate utf8_unicode_ci,
	parser_active tinyint(1) default '1',
	PRIMARY KEY  (parser_id)
	) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;");

	$lines = file("system/install/install.parser.sql");
	foreach($lines as $line)
	{
	//$line = str_replace('sed_', $cfg['mysqldb'], $line);
	$adminmain .= sed_query_chk($line);
	}
	$adminmain .= "-----------------------<br />";
	
	$sqlqr = "UPDATE ".$cfg['sqldbprefix']."stats SET stat_value='125' WHERE stat_name='version'";
	$adminmain .= sed_query_chk($sqlqr);

	$next = sed_buildnxtstep('130');  
	$adminmain .= "</div>";
	break;

// ------------------------------
case '130':
// ------------------------------

	$adminmain .=  "<h2>Step ".$step." : Upgrade of the SQL database from Seditio v125 to v130</h2>";
	$adminmain .= "<div class=\"log\">";
	$adminmain .= "<br />
	========================================<br />
	-------- Sed 125 to 130 ----------------<br />
	========================================<br />
	<br />";
	/*
	$adminmain .= "Uninstall All plugins<br />";
	$adminmain .= sed_plugin_uninstall('all', TRUE); 
	*/
	$adminmain .= "Fixing the bug <a href=\"http://www.neocrome.net/plug.php?e=tracker&m=bview&pr=1&id=450\">#450</a><br />";
	$sqlqr = "ALTER TABLE ".$cfg['sqldbprefix']."users CHANGE user_timezone user_timezone VARCHAR(6) NOT NULL DEFAULT '0'";
	$adminmain .= sed_query_chk($sqlqr);
	$adminmain .= "-----------------------<br />";

	$adminmain .= "Fixing the bug <a href=\"http://www.neocrome.net/plug.php?e=tracker&m=bview&pr=1&id=441\">#441</a><br />";
	$sqlqr = "UPDATE ".$cfg['sqldbprefix']."parser SET parser_code1='".sed_sql_prep('<a href="page.php?id=$1">$2</a>')."' WHERE parser_title='Page 2'";
	$adminmain .= sed_query_chk($sqlqr);
	$adminmain .= "-----------------------<br />";

	$adminmain .= "Adding the option to set a default country for the new members (Admin > Config > Users)<br />";
	$sqlqr = "INSERT INTO ".$cfg['sqldbprefix']."config (config_owner, config_cat, config_order, config_name, config_type, config_value, config_default, config_text) VALUES ('core', 'users', '02', 'defaultcountry', '1', '', '', '')";
	$adminmain .= sed_query_chk($sqlqr);
	
	$sqlqr = "UPDATE ".$cfg['sqldbprefix']."stats SET stat_value='130' WHERE stat_name='version'";
	$adminmain .= sed_query_chk($sqlqr);
	
	$adminmain .= "-----------------------<br />";

	$next = sed_buildnxtstep('150');
	$adminmain .= "</div>";
	break;

// ------------------------------
case '150':
// ------------------------------

	$adminmain .=  "<h2>Step ".$step." : Upgrade of the SQL database from Seditio v130 to v150</h2>";
	$adminmain .= "<div class=\"log\">";
	$adminmain .= "<br />
	========================================<br />
	-------- Sed 130 to 150 ----------------<br />
	========================================<br />
	<br />";
	/*
	$adminmain .= "Uninstall All plugins<br />";
	$adminmain .= sed_plugin_uninstall('all', TRUE); 
	*/
	$adminmain .= "Adding the column to store the 'displayed' thumbnail in the gallery<br />";
	$sqlqr = "ALTER TABLE ".$cfg['sqldbprefix']."pfs_folders ADD pff_sample INT(11) NOT NULL DEFAULT '0' AFTER pff_isgallery";
	$adminmain .= sed_query_chk($sqlqr);
	$adminmain .= "-----------------------<br />";

	$adminmain .= "Adding the Gallery into the core<br />";
	$sqlqr = "INSERT INTO ".$cfg['sqldbprefix']."core (ct_code, ct_title, ct_version, ct_state, ct_lock) VALUES ('gallery', 'Gallery', '150', '1', '0')";
	$adminmain .= sed_query_chk($sqlqr);

	$sqlqr = "INSERT INTO ".$cfg['sqldbprefix']."config (config_owner, config_cat, config_order, config_name, config_type, config_value, config_default)
	VALUES ('core', 'gallery', '01', 'disable_gallery', '3', '0', '' )";
	$adminmain .= sed_query_chk($sqlqr);

	$sqlqr = "INSERT INTO ".$cfg['sqldbprefix']."config (config_owner, config_cat, config_order, config_name, config_type, config_value, config_default)
	VALUES ('core', 'gallery', '10', 'gallery_gcol', '2', '5', '' )";
	$adminmain .= sed_query_chk($sqlqr);

	$sqlqr = "INSERT INTO ".$cfg['sqldbprefix']."config (config_owner, config_cat, config_order, config_name, config_type, config_value, config_default)
	VALUES ('core', 'gallery', '11', 'gallery_bcol', '2', '6', '' )";
	$adminmain .= sed_query_chk($sqlqr);

	$sqlqr = "INSERT INTO ".$cfg['sqldbprefix']."config (config_owner, config_cat, config_order, config_name, config_type, config_value, config_default)
	VALUES ('core', 'gallery', '12', 'gallery_imgmaxwidth', '2', '600', '' )";
	$adminmain .= sed_query_chk($sqlqr);

	$sqlqr = "INSERT INTO ".$cfg['sqldbprefix']."config (config_owner, config_cat, config_order, config_name, config_type, config_value, config_default)
	VALUES ('core', 'gallery', '20', 'gallery_logofile', '1', '', '' )";
	$adminmain .= sed_query_chk($sqlqr);

	$sqlqr = "INSERT INTO ".$cfg['sqldbprefix']."config (config_owner, config_cat, config_order, config_name, config_type, config_value, config_default)
	VALUES ('core', 'gallery', '21', 'gallery_logopos', '2', 'Bottom left', 'Top left,Top right,Bottom left,Bottom right' )";
	$adminmain .= sed_query_chk($sqlqr);

	$sqlqr = "INSERT INTO ".$cfg['sqldbprefix']."config (config_owner, config_cat, config_order, config_name, config_type, config_value, config_default)
	VALUES ('core', 'gallery', '22', 'gallery_logotrsp', '2', '50', '0,5,10,15,20,30,40,50,60,70,80,90,95,100' )";
	$adminmain .= sed_query_chk($sqlqr);

	$sqlqr = "INSERT INTO ".$cfg['sqldbprefix']."config (config_owner, config_cat, config_order, config_name, config_type, config_value, config_default)
	VALUES ('core', 'gallery', '23', 'gallery_logojpegqual', '2', '90', '0,5,10,20,30,40,50,60,70,80,90,95,100' )";

	$adminmain .= sed_query_chk($sqlqr);
	$adminmain .= "-----------------------<br />";

	$adminmain .= "Adding the rights for the gallery";
	$sqlqr = "SELECT grp_id FROM ".$cfg['sqldbprefix']."groups WHERE 1 order by grp_id ASC";
	$sql = sed_sql_query($sqlqr);

	while ($row = sed_sql_fetchassoc($sql))
	{
	if ($row['grp_id']==1 || $row['grp_id']==2)
	  {
	  $val_rights = 1;
	  $val_lock = 254;
	  }
	elseif ($row['grp_id']==3)
	  {
	  $val_rights = 0;
	  $val_lock = 255;
	  }
	elseif ($row['grp_id']==5)
	  {
	  $val_rights = 255;
	  $val_lock = 255;
	  }
	elseif ($row['grp_id']==4)
	  {
	  $val_rights = 1;
	  $val_lock = 128;
	  }
	else
	  {
	  $val_rights = 1;
	  $val_lock = 0;
	  }

	$sqlqr2 = "INSERT INTO ".$cfg['sqldbprefix']."auth (auth_groupid, auth_code, auth_option, auth_rights, auth_rights_lock, auth_setbyuserid) VALUES ('".$row['grp_id']."', 'gallery', 'a', '".$val_rights."', '".$val_lock."', 1)";
	$adminmain .= sed_cc($sqlqr2)."<br />";
	$adminmain .= sed_query_chk($sqlqr2);
	}
	sed_auth_reorder();
	sed_auth_clear('all');

	$adminmain .= "-----------------------<br />";

	$adminmain .= "Changing the PFS description to TEXT type<br />";
	$sqlqr = "ALTER TABLE ".$cfg['sqldbprefix']."pfs CHANGE pfs_desc pfs_desc TEXT NOT NULL";
	$adminmain .= sed_query_chk($sqlqr);
	$adminmain .= "-----------------------<br />";

	$adminmain .= "Updating the PFS folders<br />";
	$sqlqr = "UPDATE ".$cfg['sqldbprefix']."pfs_folders SET pff_isgallery=pff_isgallery+pff_ispublic WHERE 1";
	$adminmain .= sed_query_chk($sqlqr);

	$sqlqr = "ALTER TABLE ".$cfg['sqldbprefix']."pfs_folders DROP pff_ispublic";
	$adminmain .= sed_query_chk($sqlqr);

	$sqlqr = "ALTER TABLE ".$cfg['sqldbprefix']."pfs_folders CHANGE pff_isgallery pff_type TINYINT(1) NOT NULL DEFAULT '0'";
	$adminmain .= sed_query_chk($sqlqr);
	$adminmain .= "-----------------------<br />";
	
	$sqlqr = "UPDATE ".$cfg['sqldbprefix']."stats SET stat_value='150' WHERE stat_name='version'";
	$adminmain .= sed_query_chk($sqlqr);

	// $adminmain .= "Deprecating the folder storage mode for the PFS<br />";
	// $sqlqr = "DELETE FROM ".$cfg['sqldbprefix']."config  WHERE config_name='pfsuserfolder'";
	// 
	// $sql = sed_query_chk($sqlqr);
	// $adminmain .= "-----------------------<br />";
	$next = sed_buildnxtstep('160');
	$adminmain .= "</div>";
	break;

// ------------------------------
case '160':
// ------------------------------

	$adminmain .=  "<h2>Step ".$step." : Upgrade of the SQL database from Seditio v150 to v160</h2>";
	$adminmain .= "<div class=\"log\">";
	$adminmain .= "<br />
	========================================<br />
	-------- Sed 150 to 160 ----------------<br />
	========================================<br />
	<br />";
	/*
	$adminmain .= "Uninstall All plugins<br />";
	$adminmain .= sed_plugin_uninstall('all', TRUE); 
	*/
	$adminmain .= "Adding the 'is_html' column to comments...<br />";
	$sqlqr = "ALTER TABLE ".$cfg['sqldbprefix']."com ADD com_text_ishtml TINYINT(1) DEFAULT '0' AFTER com_text";
	$adminmain .= sed_query_chk($sqlqr);

	$adminmain .= "Adding the 'is_html' column to forum posts...<br />";
	$sqlqr = "ALTER TABLE ".$cfg['sqldbprefix']."forum_posts ADD fp_text_ishtml TINYINT(1) DEFAULT '0' AFTER fp_text";
	$adminmain .= sed_query_chk($sqlqr);

	$adminmain .= "Adding the 'is_html' column to pages, ...<br />";
	$sqlqr = "ALTER TABLE ".$cfg['sqldbprefix']."pages ADD page_text_ishtml TINYINT(1) DEFAULT '0' AFTER page_text";
	$adminmain .= sed_query_chk($sqlqr);
		   
	$adminmain .= "Adding the 'is_html' column to private messages...<br />";
	$sqlqr = "ALTER TABLE ".$cfg['sqldbprefix']."pm ADD pm_text_ishtml TINYINT(1) DEFAULT '0' AFTER pm_text";
	$adminmain .= sed_query_chk($sqlqr);
		 
	$adminmain .= "Adding the 'is_html' column to user text...<br />";
	$sqlqr = "ALTER TABLE ".$cfg['sqldbprefix']."users ADD user_text_ishtml TINYINT(1) DEFAULT '0' AFTER user_text";
	$adminmain .= sed_query_chk($sqlqr);

	$adminmain .= "Cleaning the configuration table...<br />";
	$sqlqr = "DELETE FROM ".$cfg['sqldbprefix']."config WHERE config_cat='page' AND config_name='allowphp_pages'";
	$adminmain .= sed_query_chk($sqlqr);

	$sqlqr = "DELETE FROM ".$cfg['sqldbprefix']."config WHERE config_cat='pm' AND config_name='keepoldpms'";
	$adminmain .= sed_query_chk($sqlqr);
									  
	$adminmain .= "Removing the plugin Textboxer 2<br />";
	$adminmain .= sed_plugin_uninstall('textboxer2');

	$adminmain .= "Clearing the trashcan...<br />";
	$adminmain .= sed_query_chk("TRUNCATE TABLE ".$cfg['sqldbprefix']."trash");

	$adminmain .= "Clearing the internal SQL cache...<br />";
	$adminmain .= sed_query_chk("TRUNCATE TABLE ".$cfg['sqldbprefix']."cache");
	
	$sqlqr = "UPDATE ".$cfg['sqldbprefix']."stats SET stat_value='160' WHERE stat_name='version'";
	$adminmain .= sed_query_chk($sqlqr);

	$next = sed_buildnxtstep('171');
	$adminmain .= "</div>";
	break;
	
	// ------------------------------
	case '171':
	// ------------------------------
	
	$adminmain .=  "<h2>Step ".$step." : Upgrade of the SQL database from Seditio v160 to v171</h2>";
	$adminmain .= "<div class=\"log\">";
	$adminmain .= "<br />
	========================================<br />
	-------- Sed 160 to 171 ----------------<br />
	========================================<br />
	<br />";
	/*
	$adminmain .= "Uninstall All plugins<br />";
	$adminmain .= sed_plugin_uninstall('all', TRUE); 
	*/
	$sqlqr = "ALTER TABLE ".$cfg['sqldbprefix']."pages DROP `user_jrnpagescount`";
	$adminmain .= sed_query_chk($sqlqr);

	$sqlqr = "ALTER TABLE ".$cfg['sqldbprefix']."pages DROP `user_jrnupdated`";
	$adminmain .= sed_query_chk($sqlqr);
	
	$sqlqr = "UPDATE ".$cfg['sqldbprefix']."stats SET stat_value='171' WHERE stat_name='version'";
	$adminmain .= sed_query_chk($sqlqr);
	
	$next = sed_buildnxtstep('172'); 
	$adminmain .= "</div>"; 
	break;
	
// ------------------------------
case '172':
// ------------------------------

	$adminmain .=  "<h2>Step ".$step." : Upgrade of the SQL database from Seditio v171 to v172</h2>";
	$adminmain .= "<div class=\"log\">";
	$adminmain .= "<br />
	========================================<br />
	-------- Sed 171 to 172 ----------------<br />
	========================================<br />
	<br />";
	
	$adminmain .= "Uninstall All plugins<br />";
	$adminmain .= sed_pl_uninstall('all', TRUE); 
	
	$adminmain .= "Adding the 'user_salt' column to users...<br />";
	$sqlqr = "ALTER TABLE ".$cfg['sqldbprefix']."users ADD user_salt varchar(16) NOT NULL DEFAULT '' AFTER user_password";
	$adminmain .= sed_query_chk($sqlqr);

	$adminmain .= "Adding the 'user_secret' column to users...<br />";
	$sqlqr = "ALTER TABLE ".$cfg['sqldbprefix']."users ADD user_secret varchar(32) NOT NULL DEFAULT '' AFTER user_salt";
	$adminmain .= sed_query_chk($sqlqr);

	$adminmain .= "Adding the 'user_passtype' column to users...<br />";
	$sqlqr = "ALTER TABLE ".$cfg['sqldbprefix']."users ADD user_passtype tinyint(1) NOT NULL DEFAULT '0' AFTER user_secret";
	$adminmain .= sed_query_chk($sqlqr);

	$adminmain .= "Adding the Pages new config into the core<br />";
	$sqlqr = "INSERT INTO ".$cfg['sqldbprefix']."config (config_owner, config_cat, config_order, config_name, config_type, config_value, config_default)
	VALUES ('core', 'page', '03', 'showpagesubcatgroup', 3, '0', '')";
	$adminmain .= sed_query_chk($sqlqr);

	$adminmain .= "Adding the Pages new config into the core<br />";
	$sqlqr = "INSERT INTO ".$cfg['sqldbprefix']."config (config_owner, config_cat, config_order, config_name, config_type, config_value, config_default)
	VALUES ('core', 'comments', '03', 'showcommentsonpage', 3, '0', '')";
	$adminmain .= sed_query_chk($sqlqr);

	$adminmain .= "Adding the PFS new config into the core<br />";
	$sqlqr = "INSERT INTO ".$cfg['sqldbprefix']."config (config_owner, config_cat, config_order, config_name, config_type, config_value, config_default)
	VALUES ('core', 'pfs', '02', 'pfs_filemask', 3, '0', '')";
	$adminmain .= sed_query_chk($sqlqr);

	$adminmain .= "Adding the 'fs_parentcat' column to forums...<br />";
	$sqlqr = "ALTER TABLE ".$cfg['sqldbprefix']."forum_sections ADD fs_parentcat smallint(1) unsigned NOT NULL DEFAULT '0' AFTER fs_category";
	$adminmain .= sed_query_chk($sqlqr);
	
	$sqlqr = "UPDATE ".$cfg['sqldbprefix']."stats SET stat_value='172' WHERE stat_name='version'";
	$adminmain .= sed_query_chk($sqlqr);

	$next = sed_buildnxtstep('173');
	$adminmain .= "</div>";
	break;
	
// ------------------------------
case '173':
// ------------------------------

	$adminmain .=  "<h2>Step ".$step." : Upgrade of the SQL database from Seditio v172 to v173</h2>";
	$adminmain .= "<div class=\"log\">";
	$adminmain .= "<br />
	========================================<br />
	-------- Sed 172 to 173 ----------------<br />
	========================================<br />
	<br />";

	$adminmain .= "Clearing the internal SQL cache...<br />";
	$adminmain .= sed_query_chk("TRUNCATE TABLE ".$cfg['sqldbprefix']."cache");

	$adminmain .= "Updating parser table<br />";
	$sqlqr = "UPDATE ".$cfg['sqldbprefix']."parser SET parser_code1 = '<!--readmore-->' WHERE parser_bb1 = '[more]'";
	$adminmain .= sed_query_chk($sqlqr);

	$pluginstoinstall = array('adminqv','cleaner','contact','massmovetopics','news','passrecover','recentitems','search','statistics','syscheck','whosonline');
	$pluginstoinstall_html = array('ckeditor','jevix','syntaxhighlight');
	$pluginstoinstall_bbcode = array('parserman','textboxer2');
	
	foreach ($pluginstoinstall as $k => $v)
	{
		$adminmain .= "Install the plugin ".$v."<br />";
		$adminmain .= sed_plugin_install($v);
	}
	
	if ($cfg['textmode'] == "html")
	  {
		foreach ($pluginstoinstall_html as $k => $v)
		{
			$adminmain .= "Install the plugin ".$v."<br />";
			$adminmain .= sed_plugin_install($v);
		}
	  }
	else 
	  {
		foreach ($pluginstoinstall_bbcode as $k => $v)
		{
			$adminmain .= "Install the plugin ".$v."<br />";
			$adminmain .= sed_plugin_install($v);
		}      
	  }
	  
	$adminmain .= "Adding the 'structure_allowcomments' column to structure...<br />";
	$sqlqr = "ALTER TABLE ".$cfg['sqldbprefix']."structure ADD structure_allowcomments tinyint(1) NOT NULL DEFAULT '1' AFTER structure_order";
	$adminmain .= sed_query_chk($sqlqr);

	$adminmain .= "Adding the 'structure_allowratings' column to structure...<br />";
	$sqlqr = "ALTER TABLE ".$cfg['sqldbprefix']."structure ADD structure_allowratings tinyint(1) NOT NULL DEFAULT '1' AFTER structure_allowcomments";
	$adminmain .= sed_query_chk($sqlqr);

	$adminmain .= "Adding the 'page_allowcomments' column to pages...<br />";
	$sqlqr = "ALTER TABLE ".$cfg['sqldbprefix']."pages ADD page_allowcomments tinyint(1) NOT NULL DEFAULT '1' AFTER page_count";
	$adminmain .= sed_query_chk($sqlqr);

	$adminmain .= "Adding the 'page_allowratings' column to pages...<br />";
	$sqlqr = "ALTER TABLE ".$cfg['sqldbprefix']."pages ADD page_allowratings tinyint(1) NOT NULL DEFAULT '1' AFTER page_allowcomments";
	$adminmain .= sed_query_chk($sqlqr);

	$adminmain .= "Adding the 'maxcommentsperpage' new config into the core<br />";
	$sqlqr = "INSERT INTO ".$cfg['sqldbprefix']."config (config_owner, config_cat, config_order, config_name, config_type, config_value, config_default)
	VALUES ('core', 'comments', '05', 'maxcommentsperpage', 2, '30', '')";
	$adminmain .= sed_query_chk($sqlqr);

	$adminmain .= "Adding the 'maxtimeallowcomedit' new config into the core<br />";
	$sqlqr = "INSERT INTO ".$cfg['sqldbprefix']."config (config_owner, config_cat, config_order, config_name, config_type, config_value, config_default)
	VALUES ('core', 'comments', '06', 'maxtimeallowcomedit', 2, '15', '')";
	$adminmain .= sed_query_chk($sqlqr);

	$adminmain .= "Adding the 'commentsorder' new config into the core<br />";
	$sqlqr = "INSERT INTO ".$cfg['sqldbprefix']."config (config_owner, config_cat, config_order, config_name, config_type, config_value, config_default)
	VALUES ('core', 'comments', '11', 'commentsorder', 2, 'ASC', '')";
	$adminmain .= sed_query_chk($sqlqr);

	$adminmain .= "Adding the 'defskin' new hidden config into the core<br />";
	$sqlqr = "INSERT INTO ".$cfg['sqldbprefix']."config (config_owner, config_cat, config_order, config_name, config_type, config_value, config_default)
	VALUES ('core', 'skin', '16', 'defskin', 7, '', '')";
	$adminmain .= sed_query_chk($sqlqr);
	
  $adminmain .= "Adding the RSS new configs into the core<br />";
  $sqlqr = "INSERT INTO ".$cfg['sqldbprefix']."config (config_owner, config_cat, config_order, config_name, config_type, config_value, config_default)
  VALUES ('core', 'rss', '01', 'disable_rss', 3, '0', '')";
  $sql = sed_query_chk($sqlqr);
  
  $sqlqr = "INSERT INTO ".$cfg['sqldbprefix']."config (config_owner, config_cat, config_order, config_name, config_type, config_value, config_default)
  VALUES ('core', 'rss', '02', 'disable_rsspages', 3, '0', '')";
  $adminmain .= sed_query_chk($sqlqr);
  
  $sqlqr = "INSERT INTO ".$cfg['sqldbprefix']."config (config_owner, config_cat, config_order, config_name, config_type, config_value, config_default)
  VALUES ('core', 'rss', '03', 'disable_rsscomments', 3, '0', '')";
  $adminmain .= sed_query_chk($sqlqr);
  
  $sqlqr = "INSERT INTO ".$cfg['sqldbprefix']."config (config_owner, config_cat, config_order, config_name, config_type, config_value, config_default)
  VALUES ('core', 'rss', '04', 'disable_rssforums', 3, '0', '')";
  $adminmain .= sed_query_chk($sqlqr);
  
  $sqlqr = "INSERT INTO ".$cfg['sqldbprefix']."config (config_owner, config_cat, config_order, config_name, config_type, config_value, config_default)
  VALUES ('core', 'rss', '05', 'rss_timetolive', 2, '300', '')";
  $adminmain .= sed_query_chk($sqlqr);
  
  $sqlqr = "INSERT INTO ".$cfg['sqldbprefix']."config (config_owner, config_cat, config_order, config_name, config_type, config_value, config_default)
  VALUES ('core', 'rss', '06', 'rss_maxitems', 2, '30', '')";
  $adminmain .= sed_query_chk($sqlqr);
  
  $sqlqr = "INSERT INTO ".$cfg['sqldbprefix']."config (config_owner, config_cat, config_order, config_name, config_type, config_value, config_default)
  VALUES ('core', 'rss', '07', 'rss_defaultcode', 2, 'news', '')";
  $adminmain .= sed_query_chk($sqlqr);
  
	$sqlqr = "UPDATE ".$cfg['sqldbprefix']."stats SET stat_value='173' WHERE stat_name='version'";
	$adminmain .= sed_query_chk($sqlqr);
	
	$next = sed_buildnxtstep("end");
	$adminmain .= "</div>";
	break;

// ------------------------------
case 'end':
// ------------------------------
	
	$adminmain .=  "<h2>Done! : Upgrade of the SQL database from Seditio v".$version." to v".$cfg['version']." complete!</h2>";	
	$adminmain .= "<div class=\"log\">";
	$adminmain .= "Changing the SQL version number to ".$cfg['version']."...<br />";
	$adminmain .= sed_query_chk("UPDATE ".$cfg['sqldbprefix']."stats SET stat_value=".$cfg['version']." WHERE stat_name='version'");
	$adminmain .= "</div>"; 
	$adminmain .= "<strong>Done !<br />&nbsp;<br /><strong><u>Now DELETE this upgrade tool from your web root to avoid security issues !</u></strong><br />&nbsp;<br /><a href=\"index.php\">Once done, click here to go to the home page...</a>";
		
	break;	
	
	default:
	die ('Wrong URL !');
	break;
}	
  

$adminmain .= "<div style=\"padding:16px;\">".$next."</div>";

echo $adminmain;
echo "<body>
</html>";

@ob_end_flush();
@ob_end_flush();

?>
